#include "../bdtypes.h"
#include "../bdfunc.h"
#include "../bdglobal.h"
#include "../generator.h"

Obj3d *pPlane1, *pPlane2, *pPlane3, *pPlane4, *pPlane5, *pPlane6;
static float Matrix[16], Matrix2[16];

void LInit_Planes()
{
	pPlane1 = GenerateFloor(2,2, 160000, 160000, 2560, 2560);
	pPlane2 = GenerateFloor(2,2, 160000, 160000, 2560, 2560);
	pPlane3 = GenerateFloor(2,2, 160000, 160000, 2560, 2560);
	pPlane4 = GenerateFloor(2,2, 160000, 160000, 2560, 2560);
	pPlane5 = GenerateFloor(2,2, 160000, 160000, 2560, 2560);
	pPlane6 = GenerateFloor(2,2, 160000, 160000, 2560, 2560);
	
	BeIdentityMatrix(Matrix);
	RotateXMatrix(Matrix2, Matrix, 8192/4); // PI/2
	TranslateMatrix(Matrix2, 0, 1000, 1);
	ApplyMatrix(pPlane1, Matrix2);

	BeIdentityMatrix(Matrix);
	RotateXMatrix(Matrix2, Matrix, 8192/4);
	TranslateMatrix(Matrix2, 0, 3000, 1);
	ApplyMatrix(pPlane3, Matrix2);

	BeIdentityMatrix(Matrix);
	RotateXMatrix(Matrix2, Matrix, 8192/4);
	TranslateMatrix(Matrix2, 0, 6000, 1);
	ApplyMatrix(pPlane5, Matrix2);

	BeIdentityMatrix(Matrix);
	RotateXMatrix(Matrix2, Matrix, 8192/4);
	TranslateMatrix(Matrix2, 0, -1000, 1);
	ApplyMatrix(pPlane2, Matrix2);

	BeIdentityMatrix(Matrix);
	RotateXMatrix(Matrix2, Matrix, 8192/4);
	TranslateMatrix(Matrix2, 0, -3000, 1);
	ApplyMatrix(pPlane4, Matrix2);

	BeIdentityMatrix(Matrix);
	RotateXMatrix(Matrix2, Matrix, 8192/4);
	TranslateMatrix(Matrix2, 0, -6000, 1);
	ApplyMatrix(pPlane6, Matrix2);

	PrepareTextureFromArray(g_PicTour, 256, 256, &g_TextureTour);
}

void QInit_Planes()
{
	grDepthBufferMode(GR_DEPTHBUFFER_WBUFFER);
	grDepthBufferFunction(GR_CMP_ALWAYS);
	grAlphaCombine(GR_COMBINE_FUNCTION_BLEND_OTHER, GR_COMBINE_FACTOR_ONE,
					GR_COMBINE_LOCAL_NONE, GR_COMBINE_OTHER_CONSTANT, FXFALSE);
	grAlphaBlendFunction(GR_BLEND_ONE, GR_BLEND_ONE, GR_BLEND_ZERO, GR_BLEND_ZERO);

	/*grColorCombine(GR_COMBINE_FUNCTION_SCALE_OTHER,
					GR_COMBINE_FACTOR_ONE,
					GR_COMBINE_LOCAL_NONE, GR_COMBINE_OTHER_TEXTURE, FXFALSE);*/
	grColorCombine(GR_COMBINE_FUNCTION_SCALE_OTHER,
					GR_COMBINE_FACTOR_LOCAL,
					GR_COMBINE_LOCAL_CONSTANT, GR_COMBINE_OTHER_TEXTURE, FXFALSE);

	grChromakeyMode(GR_CHROMAKEY_DISABLE);
	grCullMode(GR_CULL_DISABLE);

	g_demostate.ClearColor = 0;

	grFogMode(GR_FOG_WITH_TABLE);
	grFogColorValue(0);
	grFogTable(g_FogPlanes);

	DownloadTexture(&g_TextureTour);
	SelectTexture(g_TextureTour);
}

void Effect_Planes()
{
	int Tmp;

	BeIdentityMatrix(Matrix);
	TranslateMatrix(Matrix, g_demostate.TickInEffect*8.f, 0, g_demostate.TickInEffect*8.f);

	Tmp = g_demostate.TickInEffect&(~8192*4);

	/*RotateXMatrix(Matrix2, Matrix, g_demostate.TickInEffect&(~1023));
	RotateYMatrix(Matrix, Matrix2, g_demostate.TickInEffect&(~1023));
	RotateZMatrix(Matrix2, Matrix, g_demostate.TickInEffect&(~1023));*/

	RotateXMatrix(Matrix2, Matrix, g_demostate.TickInEffect);
	RotateYMatrix(Matrix, Matrix2, g_demostate.TickInEffect);
	RotateZMatrix(Matrix2, Matrix, g_demostate.TickInEffect);

	//ScaleMatrix(Matrix, 1.f, 1.f, CosTable[(g_demostate.TickInEffect*4)&8191]+1.4f);

	grConstantColorValue(0x00B8B8B8);
	DrawWithMatrix(pPlane1, Matrix, 0, 0, 0);
	DrawWithMatrix(pPlane2, Matrix, 0, 0, 0);
	grConstantColorValue(0x00D8D8D8);
	DrawWithMatrix(pPlane3, Matrix, 0, 0, 0);
	DrawWithMatrix(pPlane4, Matrix, 0, 0, 0);
	grConstantColorValue(0xffffffff);
	DrawWithMatrix(pPlane5, Matrix, 0, 0, 0);
	DrawWithMatrix(pPlane6, Matrix, 0, 0, 0);
}

void ByeBye_Planes()
{
	FreeTexture(&g_TextureTour);
}